﻿********************************************************************************
***   Syntax-File zum Lehrbuch "Statistik. Eine Einführung für Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geißler
********************************************************************************

************************************
*** Kap. 3: Univariate Analysen ****
************************************

*  Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und führen Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch".


*** Abschnitt 3.1 - Darstellung von Verteilungen.


* Beispiel 3.2.
GET FILE = "glhsteach.sav".
TEMPORARY.
SELECT IF (kohorte = 1971).
FREQUENCIES bildjahr.


* Beispiel 3.4.
GET FILE="oecd_llg.sav".
GRAPH
  / HISTOGRAM lfp07_age2549.


** Beispiele 3.5 (Abb. 3.3), 3.7 (Abb. 3.5)  und 3.24.
GET FILE="soep_llg.sav".
TEMPORARY.
SELECT IF geschl EQ 1.
EXAMINE height 
  /STATISTICS NONE
  /PLOT HISTOGRAM STEM
  /PERCENTILES(2.5 16 84 97.5).


* Beispiel 3.8.
* Kerndichteschätzer mit SPSS sind eine sehr mühsame Angelegenheit. Bei Bedarf
  kann man im Internet Quellen finden (leichter unter dem englischen Begriff
  kernel density).

* Beispiel 3.9.
GET FILE = "glhsteach.sav".
TEMPORARY.
SELECT IF (kohorte = 1971).
GRAPH
  /LINE(SIMPLE) = CUPCT BY bildjahr.

* Beispiel 3.10.
GET FILE = "glhsteach.sav".
TEMPORARY.
SELECT IF (kohorte = 1964).
GRAPH
  /LINE(SIMPLE) = CUPCT BY jobat30_trei.



*** Abschnitte 3.2 bis 3.4: Maße der zentralen Tendenz, Quantile, Streuung etc.


* Beispiel 3.11.
* Der folgende Befehl erzeugt auch Output für weitere Beispiele.
GET FILE="oecd_llg.sav".
FREQUENCIES lfp07_age2549
   /STATISTICS ALL
  	/ FORMAT NOT
  	/ PERCENTILES = 25 50 75.


* Beispiel 3.12.
* Der folgende Befehl erzeugt auch Output für weitere Beispiele.
GET FILE="glhsteach.sav".
TEMPORARY.
SELECT IF sex EQ 1.
MEANS jobat30_trei BY kohorte
  /CELLS COUNT MEAN MEDIAN STDDEV VARIANCE SKEW KURT.


* Beispiel 3.13.
GET FILE="glhsteach.sav".
MEANS n_geschw BY kohorte
  /CELLS COUNT MEAN MEDIAN SKEW.


* Beispiel 3.14.
GET FILE="oecd_llg.sav".
FREQUENCIES fertrate08
   /STATISTICS ALL
  	/ FORMAT NOT
  	/ PERCENTILES = 2.5 16 50 84 97.5.



* Beispiel 3.15.
* Die Ergebnisse finden sich bei Beispiel 3.11.

* Beispiel 3.16 bezieht sich auf Ablesen aus einer Tabelle (siehe Beispiel 3.2).

* Beispiele 3.17 und 3.18.
* Die Ergebnisse finden sich bei Beispiel 3.11.
* Beachten Sie, dass SPSS für Quantile eine abweichende Formel verwendet
  und folglich teilweise vom Buch abweichende Werte ausgibt.


* Beispiel 3.19.
GET FILE="oecd_llg.sav".
EXAMINE lfp07_age2549
  	/ STAT NONE
  	/ NOTOTAL
  	/ PLOT BOX.


* Beispiel 3.20.
GET FILE="glhsteach.sav".
TEMPORARY.
SELECT IF sex EQ 1 AND kohorte NE 1960.
EXAMINE jobat30_trei BY kohorte
  	/ STAT NONE
  	/ NOTOTAL
  	/ PLOT BOX.

* Beispiel 3.21.
* Die Varianz wurde bereits bei Beispiel 3.11 berechnet, allerdings als 
  Schätzwert aus einer Stichprobe. Die korrekte Größe (Varianz, die die 
  vorliegenden Daten beschreibt) muss von Hand berechnet werden.


* Beispiel 3.22.
GET FILE="glhsteach.sav". 
TEMPORARY.
SELECT IF kohorte EQ 1971.
FREQUENCIES bildjahr
  /STATISTICS VAR STDDEV.

* Die Varianzen für das Berufsprestige wurden bereits bei Beispiel 3.12
   berechnet (ebenso wie die Standardabweichungen). 

* Beispiel 3.24.
GET FILE="soep_llg.sav".
TEMPORARY.
SELECT IF geschl EQ 1.
EXAMINE height/ PLOT NONE / STATISTICS DESCRIPTIVES/PERCENTILE(2.5 16 84 97.5).


* Beispiel 3.25.
GET FILE="glhsteach.sav".
SORT CASES BY kohorte sex.
SPLIT FILE BY kohorte sex.
DESCRIPTIVES VARIABLES = jobat30_trei (zjob30).
SPLIT FILE OFF.


* Beispiel 3.26.
* Die Werte finden sich bei Beispiel 3.24.
* Beachten Sie, dass SPSS etwas abweichende Formeln verwendet
  und folglich geringfügig andere Werte ausgibt, als im Buch genannt werden.



