﻿
********************************************************************************
***   Syntax-File zum Lehrbuch "Statistik. Eine Einführung für Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geißler
********************************************************************************

************************************
*** Kap. 4: Inferenzstatistik ***
************************************.

*  Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und führen Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch".


*** Abschnitt 4.2 Konfidenzintervalle.

* Beispiel 4.7.
GET FILE = "glhsteach.sav".
TEMPORARY.
SELECT IF (kohorte = 1920) AND (sex = 1).
T-TEST
  /TESTVAL = 0
  /VARIABLES = jobat30_trei.



*** Abschnitt 4.3 Statistische Tests.


* Beispiele 4.10 und 4.11.
GET FILE="glhsteach.sav".
COMPUTE alt1job = trunc((job1_start - geburt)/12).
TEMPORARY.
SELECT IF (sex = 1).
T-TEST GROUPS = kohorte (1930, 1955) / VAR jobat30_trei alt1job.


* Beispiel 4.12.

DATA LIST LIST
 /Land (A2) quote85 quote90.
BEGIN DATA.
DE 51.9 55.5
FR 55.6 57.2
NL 40.9 53.1
SE 79.3 82.5
ES 34.7 34.6
GB 62.4 67.3
US 64.1 67.8
END DATA.
T-TEST PAIRS = quote85 quote90.


* Beispiel 4.13.
DATA LIST LIST
 /kohorte jobat30_trei.
BEGIN DATA.
1930 29
1930 30
1930 31
1930 32
1930 34
1930 38
1930 40
1930 42
1930 44
1930 47
1930 50
1930 65
1955 25
1955 28
1955 35
1955 41
1955 43
1955 46
1955 51
1955 54
1955 55
1955 56
1955 61
1955 79
END DATA.
npar tests
  	/ m-w jobat30_trei by kohorte (1930,1955).



* Beispiel 4.14.
GET FILE="glhsteach.sav".
* Der folgende Test entspricht nicht exakt dem im Buch vorgestellten.
TEMPORARY.
SELECT IF sex EQ 1 AND kohorte EQ 1971.
NPAR TESTS BINOMIAL (.25)=jobtil25(0,1).


* Beispiel 4.15.
GET FILE="glhsteach.sav".
TEMPORARY.
SELECT IF sex EQ 1 AND kohorte EQ 1920.
T-TEST /TESTVAL = 38.77 / VARIABLES = jobat30_trei.
* SPSS gibt nur den p-Wert aus.



**** Abschnitt 4.4  Komplexe Stichproben.


* Beispiel 4.21.
GET FILE="soep_llg.sav".
IF (sample1 = 7) ost = 1.
IF (sample1) = 1 ost = 0.
EXECUTE.
CSPLAN ANALYSIS
  /PLAN FILE = "soep_llg.csaplan"
  /PLANVARS ANALYSISWEIGHT=pw
  /SRSESTIMATOR TYPE=WR
  /PRINT PLAN
  /DESIGN STRATA = strat CLUSTER = psu
  /ESTIMATOR TYPE = WR.
CSGLM up0110 BY ost
  /PLAN FILE = "soep_llg.csaplan"
  /MODEL ost
  /STATISTICS PARAMETER SE CINTERVAL TTEST DEFF.
REGRESSION
  /STATISTICS COEFF
  /DEPENDENT up0110
  /METHOD = ENTER ost.



