﻿
********************************************************************************
***   Syntax-File zum Lehrbuch "Statistik. Eine Einführung für Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geißler
********************************************************************************

************************************
*** Kap. 5: Bivariate Analysen ***
************************************.

*  Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und führen Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch".


* ---------------------------------------------------------------------------- *


*** 5.1 - Analyse von Kreuztabellen
 
* Beispiele 5.1 und 5.2 (Tabellen 5.2 und 5.4, Abb. 5.1 und 5.2).
GET FILE='glhsteach.sav'.

RECODE kohorte (1940 = 1) (1955 = 2) (1971 = 3)  INTO gebkoho.
VALUE LABELS gebkoho
   1 '1939-1941'
   2 '1954-1956'
   3 '1971'.
EXECUTE.

CROSSTABS jobtil25 BY gebkoho.

CROSSTABS jobtil25 BY gebkoho
   /CELLS=COUNT COLUMN.

GRAPH
  /BAR(STACK) = COUNT BY gebkoho BY jobtil25.


* Beispiele 5.3, 5.4 und 5.5.
RECODE kohorte (1955 = 0) (1940 = 1)  into kohortt.

CROSSTABS kohortt BY jobtil25 
  /CELL COUNT ROW
  /STAT RISK.


* Beispiel 5.6 (Chi-Quadrat-Test).
RECODE job1_egp (32 = 31) (43 = 42) (60 = 50) (72 = 71) 
  (ELSE = COPY) INTO j1egp_r.

TEMPORARY.
SELECT IF NOT MISSING(gebkoho).

CROSSTABS j1egp_r BY sex
  /STATISTICS = CHISQ.




*** 5.2 - Zusammenhang zweier metrischer Merkmale

* Beispiel 5.8.
GET FILE = "oecd_llg.sav".

CORRELATIONS lfp07_moms WITH enrol_cc
  /STATISTICS = XPROD.

GRAPH
  /SCATTERPLOT = lfp07_moms WITH enrol_cc.



*** 5.3 - Zusammenhaenge zwischen ordinalskalierten Merkmalen

* Beispiel 5.12.
DATA LIST LIST
 /up8603 up8604.
BEGIN DATA.
1 2
2 2
2 2
2 2
2 4
3 3
3 3
3 5
4 3
5 3
END DATA.

CROSSTABS up8603 BY up8604
  /FORMAT NOTABLE
  /STAT BTAU GAMMA D.

NONPAR CORR
  /VARIABLES=up8603 up8604
  /PRINT=SPEARMAN.



*** 5.4 - Varianzanalyse

* Beispiele 5.14 und 5.15.
GET FILE = "oecd_llg.sav".

UNIANOVA lfp08 BY EA1990
  /PRINT = ETASQ HOMOGENEITY DESCRIPTIVE.


* ---------------------------------------------------------------------------- *
 

