﻿
********************************************************************************
***   Syntax-File zum Lehrbuch "Statistik. Eine Einführung für Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geißler
********************************************************************************

************************************
*** Kap. 6: Regressionsanalyse ***
************************************.

*  Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und führen Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch".


* ---------------------------------------------------------------------------- *


*** 6.1 - Idee der linearen Regressionsanalyse

* Beispiel 6.1 (Abb. 6.1).
GET FILE = "oecd_llg.sav".

COMPUTE touse = 1.
EXECUTE.
IF SYSMIS(lfp07_moms) OR SYSMIS(enrol_cc)
  OR SYSMIS(pubexp_child05) touse = 0.
EXECUTE.

TEMPORARY.
SELECT IF (touse = 1).

GRAPH
  /SCATTERPLOT = lfp07_moms WITH enrol_cc.

TEMPORARY.
SELECT IF (touse = 1).

REGRESSION
  /STATISTICS COEFF OUTS CI(95) R ANOVA
  /DEPENDENT enrol_cc
  /METHOD = ENTER lfp07_moms.



*** 6.2 - Aufstellen eines Regressionsmodells in der Praxis

* Beispiel 6.2 (Tabelle 6.1).
GET FILE = "soep_llg.sav".

MISSING VALUE upsbil (5, 7).

COMPUTE edu1 = (upsbil = 6).
COMPUTE edu2 = (upsbil = 1).
COMPUTE edu3 = (upsbil = 2).
COMPUTE edu4 = (upsbil = 3) OR (upsbil = 4).

CSPLAN ANALYSIS
  /PLAN FILE = 'soep_llg.csaplan'
  /PLANVARS ANALYSISWEIGHT = pw
  /SRSESTIMATOR TYPE = WR
  /PRINT PLAN
  /DESIGN STRATA = strat CLUSTER = psu
  /ESTIMATOR TYPE = WR.

CSGLM pcs WITH alter geschl edu1 edu2 edu3 bweight
  /PLAN FILE = 'soep_llg.csaplan'
  /MODEL bweight alter geschl edu1 edu2 edu3
  /STATISTICS PARAMETER SE CINTERVAL TTEST.


* ---------------------------------------------------------------------------- *



