
********************************************************************************
***   Do-File zum Lehrbuch "Statistik. Eine Einfhrung fr Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geiler
********************************************************************************

************************************
*** Kap. 4: Inferenzstatistik   ****
************************************

clear
set more off
version 13.0  // Version gegebenenfalls anpassen
capture log close


/* Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und fhren Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.*/
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch"
	   

**** Abschnitt 4.2  Konfidenzintervalle


* Beispiel 4.7
use "glhsteach.dta", clear
mean jobat30_trei if sex == 1 & kohorte == 1920



* Beispiel 4.8 
* Die folgenden Befehle fhren zu den im Buch auf S. 133 genannten Ergebnissen
use "glhsteach.dta", clear
gen jobtil25r = 1- jobtil25 
ci jobtil25r if sex == 1 & koho == 1971
ci jobtil25r if sex == 1 & koho == 1940

/* Die nachfolgenden Prozeduren (von S. 197 des Lehrbuchs) fhren wegen anderer
   Verfahren zu leicht abweichenden Ergebnissen, vor allem fr die ltere Kohorte */
proportion jobtil25 if sex == 1 & koho == 1971
proportion jobtil25 if sex == 1 & koho == 1940


**** Abschnitt 4.3  Statistisches Testen



* Beispiele 4.10., 4.11 lassen sich anhand der Angaben im Buch von Hand rechnen! 
* Zur Kontrolle:
use "glhsteach.dta", clear
sdtest jobat30_trei if sex == 1 & (kohorte == 1930 ///
  | kohorte == 1955), by(kohorte)
ttest jobat30_trei if sex == 1 & (kohorte == 1930 ///
  | kohorte == 1955), by(kohorte) unequal
generate alt1job = trunc((job1_start - geburt)/12)
sdtest alt1job if sex == 1 & (kohorte == 1930 ///
  | kohorte == 1955), by(kohorte)
ttest alt1job if sex == 1 & (kohorte == 1930 ///
| kohorte == 1955), by(kohorte)



* Beispiel 4.12
clear 
input str4 Land quote85 quote90
"DE" 51.9 55.5
"FR" 55.6 57.2
"NL" 40.9 53.1
"SE" 79.3 82.5
"ES" 34.7 34.6
"GB" 62.4 67.3
"US" 64.1 67.8
end
br
ttest quote85 == quote90 



* Beispiel 4.13
clear
input kohorte jobat30_trei
1930 29
1930 30
1930 31
1930 32
1930 34
1930 38
1930 40
1930 42
1930 44
1930 47
1930 50
1930 65
1955 25
1955 28
1955 35
1955 41
1955 43
1955 46
1955 51
1955 54
1955 55
1955 56
1955 61
1955 79
end
ranksum jobat30_trei, by(kohorte)



* Beispiel 4.14., 4.15
use "glhsteach.dta", clear
recode jobtil25 (0 = 1) (1 = 0), gen(jobtil25r)
prtest jobtil25r = .25 if (sex == 1 & kohorte == 1971)
ttest jobat30_trei = 38.77 if (sex == 1 & kohorte == 1920)



**** Abschnitt 4.4  Komplexe Stichproben


* Beispiel 4.21
use "soep_llg.dta", clear
svyset psu [pweight=pw], strata(strat)
svydes
generate ost = 1 if sample1 == 7
replace ost = 0 if sample1 == 1
regress up0110 ost
svy: regress up0110 ost
estat effects
