********************************************************************************
***   Do-File zum Lehrbuch "Statistik. Eine Einfhrung fr Sozialwissenschaftler"
***   (c) 2014 Wolfgang Ludwig-Mayerhofer, Uta Liebeskind, Ferdinand Geiler
********************************************************************************

************************************
*** Kap. 3: Univariate Analysen ****
************************************

clear
set more off
version 13.0  // Version gegebenenfalls anpassen
capture log close


/* Wichtig: Setzen Sie in der folgenden Zeile den Pfad zu dem Verzeichnis ein,
   in dem Sie die Datendateien abgelegt haben, und fhren Sie den Befehl
   zu Anfang jeder Auswertungssitzung aus.*/
cd "C:\Eigene Dateien\Statistik Lehrbuch\StatLehrbuch"
	   


*** 3.1 - Darstellung von Verteilungen


* Beispiel 3.2

use "glhsteach.dta", clear
tabulate bildjahr if kohorte == 1971, missing



* Beispiel 3.3, Abbildung 3.1
use "soep_llg.dta", clear
/* Leider wird bei Label 4 letzte h verschluckt. Lsst sich im
     Graphik-Editor noch ndern.*/
lab def lupinta 9 "CAPI" 8 "Schriftlich" 5 "Proxy" /// 
 3 "Ausgefllt ohne Interviewer" 4 "Teils mndlich, teils schriftlich" ///
 2 "Ausgefllt mit Interviewer" 1 "Mndliches Interview"
lab val upinta lupinta
tab upinta, gen(upintad)
gen bar = 1127/r(N) if upintad1 == 1
replace bar = 145/r(N) if upintad2 == 1
replace bar = 1149/r(N) if upintad3 == 1
replace bar = 184/r(N) if upintad4 == 1
replace bar = 3/r(N) if upintad5 == 1
replace bar = 600/r(N) if upintad6 == 1
replace bar = 1084/r(N) if upintad7 == 1
tab bar
#delimit ;
graph bar (count) bar, 
over(upinta, label(labsize(*1.2)) sort(1) descending) horizontal 
plotregion(color(white)) 
bar(1,fcolor(white) lcolor(black)) 
graphregion(color(white))
ytitle("Absolute Hufigkeit", size(*1.2))
ylabel(, labsize(*1.2) glpattern(shortdash) glcolor(gs9) ) 
name(ul_uni_verteilungen_bar, replace)
;
#delimit cr
* Der folgende Dateiname kann nach Belieben gendert werden.
graph export "SOEP-Interview-Bar.pdf", replace



* Beispiel 3.4, Abbildung 3.2 
use "oecd_llg.dta", clear
#delimit ;
hist  lfp07_age2549, freq width(5) start(55) plotregion(color(white))
fcolor(white) lcolor(black) graphregion(color(white)) 
ytitle ("Absolute Hufigkeit", size(*1.5)) 
xtitle("Erwerbsbeteiligung in Prozent", size(*1.5))
ylabel(1(2)9, nogrid angle(0) labsize(*1.25))
xlabel(, labsize(*1.25))
name(ul_uni_verteilungen_hist1, replace)
;
#delimit cr
graph export "OECD_Frauenerwerb_Hist.pdf", replace
	   

	   
* Beispiel 3.5, Abbildung 3.3 (a und b)
use "soep_llg.dta", clear	   
set scheme s1mono
hist height if geschl == 1, plotregion(style(none)) ylabel(,angle(0)) ///
 fcolor(white) lcolor(black) ///
 ylabel(, labsize(*1.65)) xlabel(,labsize(*1.65)) ///
 xtitle("Krpergre in cm", size(*1.8)) ///
 ytitle("Relative Hufigkeit", size(*1.8)) ///
 name(SOEP_Kgroesse_Hist1, replace)
graph export "SOEP_Kgroesse_Hist-1.pdf", replace

hist height if geschl == 1 , bin(20) plotregion(style(none)) ///
 ylabel(,angle(0)) fcolor(white) lcolor(black) ///
 ylabel(, labsize(*1.65)) xlabel(,labsize(*1.65)) ///
 xtitle("Krpergre in cm", size(*1.8)) ytitle("Relative Hufigkeit", size(*1.8)) ///
 name(SOEP_Kgroesse_Hist2, replace)
graph export "SOEP_Kgroesse_Hist-2.pdf", replace



** Beispiel 3.6, Abbildung 3.4
use "oecd_llg.dta", clear
stem lfp07_age2549
* Hinweis: Abb. 3.4 wird damit nicht exakt reproduziert.



** Beispiel 3.7, Abbildung 3.5
/* Stata kann mit den hier anfallenden groen Fallzahlen nicht sinnvoll umgehen
   (Stamm-Blatt-Diagramme wurden ursprnglich fr kleine Dateien entwickelt).*/

   
	   
** Beispiel 3.8, Abbildung 3.6 (a und b)
use "soep_llg.dta", clear	   
kdensity height if geschl == 1, bwidth(1) note("") ///
  plotregion(style(none)) ylabel(,angle(0) labsize(*1.65)) ///
  xlabel(,labsize(*1.65)) ///
  xtitle("Krpergre in cm", size(*1.8)) ///
  ytitle("Relative Hufigkeit", size(*1.8)) title("")
graph export "SOEP_KGroesse_kdens1.pdf", replace
kdensity height if geschl == 1, bwidth(2) note("") ///
  plotregion(style(none)) ylabel(0(0.02)0.06,angle(0) labsize(*1.65)) ///
  xlabel(,labsize(*1.65)) ///
  ysc(r(0 .06))  scheme(s1mono) ///
  xtitle("Krpergre in cm", size(*1.8)) ///
  ytitle("Relative Hufigkeit", size(*1.8)) title("")
graph export "SOEP_KGroesse_kdens2.pdf", replace



*** Beispiel 3.9, Abbildung 3.7
use "glhsteach.dta", clear
cumul bildjahr if kohorte == 1971, gen(bildkoho64) eq
tab bildkoho64
twoway (line bildkoho64 bildjahr, sort connect(stairstep) /// 
   xscale(range(8 19)) ///
   xlabel(8(1)19, labsize(*1.2)) yline(0.5, lpattern(shortdash))), ///
   xtitle("") ytitle("") title("") plotregion(style(none)) ///
   ylabel(,angle(0) labsize(*1.2))
graph export "GLHS_Bildjahr_Empvert.pdf", replace



** Beispiel 3.10, Abbildung 3.8
use "glhsteach.dta", clear
foreach X in 20 50 64 {
cumul jobat30_trei if kohorte == 19`X', gen(prestkoho`X') eq
}
twoway (line prestkoho20 jobat30_trei, sort connect(stairstep) ///
  lpattern(longdash_dot) lc(black) yline(0.75, lpattern(shortdash))) ///
 (line prestkoho50 jobat30_trei, sort connect(stairstep) lpattern(solid) ///
  lc(black)) ///
  (line prestkoho64 jobat30_trei, sort connect(stairstep) lpattern(shortdash) /// 
  lc(black)), ///
  xtitle("") ytitle("") title("") plotregion(style(none)) ylabel(,angle(0) ///
  labsize(*1.1))   legend(label(1 "Kohorte 1919-21") /// 
  label(2 "Kohorte 1949-51") label(3 "Kohorte 1964") size(*1.15))  ///
  xlabel(,labsize(*1.1)) scheme(s1mono)
graph export "GLHS_Prestige_Empvert.pdf", replace



*** Abschnitte 3.2 bis 3.4: Mae der zentralen Tendenz, Quantile, Streuung etc.


* Beispiel 3.11
use "oecd_llg.dta", clear
sum lfp07_age2549, detail  



* Beispiel 3.12 
use "glhsteach.dta", clear
by kohorte, sort: sum jobat30_trei if sex==1, d



** Beispiel 3.13 
use "glhsteach.dta", clear
mean n_geschw if kohorte==1920
mean  n_geschw if kohorte==1971



* Beispiel 3.14
use "oecd_llg.dta", clear
sum fertrate08, det


* Beispiel 3.15
* Siehe Ergebnisse 3.11


* Beispiel 3.16: bezieht sich auf ablesen aus Tabelle 3.2


* Beispiel 3.17 und 3.18
* Siehe Ergebnisse 3.11



* Beispiel 3.19, Abbildung 3.10, 
use "oecd_llg.dta", clear
graph box lfp07_age2549, intensity(0) aspectratio(2) outergap(*3) /// 
   medtype(cline)  medline(lwidth(medium) lcolor(gs0) )  ///
   ylabel(,angle(0) labsize(*1.4)) ytitle("") scheme(s1mono) 
graph export "OECD_lfp07_Box-1.pdf", replace
graph box lfp07_age2549, intensity(0) aspectratio(2) box(1, color(gs16)) ///
  outergap(*3) alsize(0) cwhiskers lines( lcolor(gs0))  medtype(marker)  ///
  ylabel(,angle(0) labsize(*1.4)) ytitle("") scheme(s1mono) 
graph export "OECD_lfp07_Box-2.pdf", replace



* Beispiel 3.20, Abbildung 3.11
use "glhsteach.dta", clear
graph box jobat30_trei if sex==1 & kohorte != 1960 & kohorte != 1971, ///
  over(kohorte) intensity(0) medtype(cline)  ///
  medline(lwidth(medium) lcolor(gs0)) ///
  ytitle("") scheme(s1mono) ylabel(,angle(0))
graph export "GLHS_Prestige_Box.pdf", replace



* Bsp. 3.21
use "oecd_llg.dta", clear
sum lfp07_age2549, d
dis r(Var) * (r(N)-1)/(r(N))  // Varianz
dis sqrt(r(Var) * (r(N)-1)/(r(N))) // Standardabweichung
dis r(sd)/r(mean) // Variationskoeffizient



* Bsp. 3.22
* Bildung von Hand nach Tabelle berechnet. Nachprfen ber:
use "glhsteach.dta", clear
sum bildjahr if kohorte==1971, det
* Prestige
by kohorte, sort: sum jobat30_trei if sex==1, d



* Bsp. 3.23 - von Hand berechnet; siehe aber auch Bsp. 3.21



* Bsp. 3.24
use "soep_llg.dta", clear
_pctile height if geschl==1, percentile(2.5 16 84 97.5)
return list



* Beispiel 3.25
use "glhsteach.dta", clear
bysort kohorte sex: egen mj30 = mean(jobat30_trei)
bysort kohorte sex: egen sdj30 = sd(jobat30_trei)
generate zj30 = (jobat30_trei - mj30) / sdj30
list kohorte zj30 jobat30_trei if jobat30_trei == 30 & sex==1



* Beispiel 	3.26
use "soep_llg.dta", clear
sum height if geschl == 1, d


